@props(['currencies' => collect()])

@php
  $list = collect($currencies);
  $primary = $list->firstWhere('is_primary', true)
             ?: $list->firstWhere('rate_to_primary', 1)
             ?: $list->first();

  $ordered = collect();
  if ($primary) {
    $ordered->push($primary);
    $ordered = $ordered->concat(
      $list->reject(fn($c) => (strtoupper($c->code ?? '') === strtoupper($primary->code ?? '')))
           ->sortBy(fn($c) => strtoupper($c->code ?? ''))
    );
  }

  // Tamaño y estilo compacto para códigos/tasas
  $curSmall = 'text-[10px] uppercase font-semibold tracking-wide';
  // Color por código
  $curClass = function($code) {
    $c = strtoupper(trim((string)$code));
    return match ($c) {
      'USD' => 'text-emerald-700',
      'CUP' => 'text-sky-700',
      default => 'text-slate-700',
    };
  };
  // Tasa sin separadores/decimales (crudo)
  $fmtRateRaw = fn($r) => (string) (int) round((float)($r ?? 0));
@endphp

@if($ordered->isNotEmpty())
  <div class="bg-white rounded-2xl border border-slate-200 p-4">
    <div class="flex flex-wrap justify-center items-center gap-3 text-center uppercase">
      @foreach($ordered as $c)
        @php
          $code = strtoupper($c->code ?? '');
          $isPrimary = $primary && strtoupper($primary->code ?? '') === $code;
          $rate = $c->rate_to_primary ?? null;
        @endphp

        <span class="inline-flex items-center gap-1 px-4 py-2 rounded-full border bg-slate-50 border-slate-200 shadow-sm
                      text-xs font-bold">
          <span class="{{ $curClass($code) }}">{{ $code }}</span>

          @unless($isPrimary)
            @if($rate)
              <span class="text-[10px] text-slate-500">({{ $fmtRateRaw($rate) }})</span>
            @endif
          @endunless
        </span>
      @endforeach
    </div>
  </div>
@endif
